"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// extensions/sud-authentication/src/extension.ts
var extension_exports = {};
__export(extension_exports, {
  activate: () => activate,
  deactivate: () => deactivate
});
module.exports = __toCommonJS(extension_exports);

// extensions/sud-authentication/src/pinkAuthenticationProvider.ts
var import_vscode2 = require("vscode");

// extensions/sud-authentication/node_modules/uuid/dist/esm-node/rng.js
var import_crypto = __toESM(require("crypto"));
var rnds8Pool = new Uint8Array(256);
var poolPtr = rnds8Pool.length;
function rng() {
  if (poolPtr > rnds8Pool.length - 16) {
    import_crypto.default.randomFillSync(rnds8Pool);
    poolPtr = 0;
  }
  return rnds8Pool.slice(poolPtr, poolPtr += 16);
}

// extensions/sud-authentication/node_modules/uuid/dist/esm-node/regex.js
var regex_default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

// extensions/sud-authentication/node_modules/uuid/dist/esm-node/validate.js
function validate(uuid) {
  return typeof uuid === "string" && regex_default.test(uuid);
}
var validate_default = validate;

// extensions/sud-authentication/node_modules/uuid/dist/esm-node/stringify.js
var byteToHex = [];
for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 256).toString(16).substr(1));
}
function stringify(arr, offset = 0) {
  const uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
  if (!validate_default(uuid)) {
    throw TypeError("Stringified UUID is invalid");
  }
  return uuid;
}
var stringify_default = stringify;

// extensions/sud-authentication/node_modules/uuid/dist/esm-node/v4.js
function v4(options, buf, offset) {
  options = options || {};
  const rnds = options.random || (options.rng || rng)();
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return stringify_default(rnds);
}
var v4_default = v4;

// extensions/sud-authentication/src/util.ts
var import_vscode = require("vscode");
var os = __toESM(require("os"));
var import_promises = require("fs/promises");
var import_path = require("path");
var passthrough = (value, resolve) => resolve(value);
function promiseFromEvent(event, adapter = passthrough) {
  let subscription;
  const cancel = new import_vscode.EventEmitter();
  return {
    promise: new Promise((resolve, reject) => {
      cancel.event((_) => reject("Cancelled"));
      subscription = event((value) => {
        try {
          Promise.resolve(adapter(value, resolve, reject)).catch(reject);
        } catch (error) {
          reject(error);
        }
      });
    }).then(
      (result) => {
        subscription.dispose();
        return result;
      },
      (error) => {
        subscription.dispose();
        throw error;
      }
    ),
    cancel
  };
}
async function getLocalConfig() {
  const userDataPath = (0, import_path.join)(os.homedir(), ".pink");
  const configPath = (0, import_path.join)(userDataPath, "api-config.json");
  try {
    const contents = await (0, import_promises.readFile)(configPath, "utf-8");
    const config = JSON.parse(contents);
    return config;
  } catch (error) {
    return {};
  }
}
var API_URL = `https://cn-000-agent-api.s01.tech`;
var AUTH0_DOMAIN = `https://auth.sud.tech`;
async function getAPIUrl() {
  const config = await getLocalConfig();
  const apiUrl = config["agentApi"] || API_URL;
  const auth0Domain = config["auth0Domain"] || AUTH0_DOMAIN;
  return { apiUrl, auth0Domain };
}
var sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));

// extensions/sud-authentication/src/keychain.ts
var Keychain = class {
  constructor(context, serviceId) {
    this.context = context;
    this.serviceId = serviceId;
  }
  async setToken(token) {
    try {
      return await this.context.secrets.store(this.serviceId, token);
    } catch (e) {
      console.error(`Failed to store token for ${this.serviceId}:`, e);
      throw e;
    }
  }
  async getToken() {
    try {
      const secret = await this.context.secrets.get(this.serviceId);
      if (secret && secret !== "[]") {
        return secret;
      }
    } catch (e) {
      console.error(`Failed to get token for ${this.serviceId}:`, e);
    }
    return void 0;
  }
  async deleteToken() {
    try {
      return await this.context.secrets.delete(this.serviceId);
    } catch (e) {
      console.error(`Failed to delete token for ${this.serviceId}:`, e);
    }
  }
};

// extensions/sud-authentication/src/pinkAuthenticationProvider.ts
var AUTH_TYPE = `pink`;
var SESSIONS_SECRET_KEY = `${AUTH_TYPE}.sessions`;
var AUTH_NAME = `PinK Authentication`;
var REFRESH_TOKEN_BUFFER_MS = 5 * 60 * 1e3;
var LOGIN_TIMEOUT_MS = 5 * 60 * 1e3;
var UriEventHandler = class extends import_vscode2.EventEmitter {
  handleUri(uri) {
    this.fire(uri);
  }
};
var pinkAuthenticationProvider = class {
  constructor(context) {
    this.context = context;
    this._keychain = new Keychain(context, SESSIONS_SECRET_KEY);
    this._sessionsPromise = this.readSessions();
    this._disposable = import_vscode2.Disposable.from(
      import_vscode2.authentication.registerAuthenticationProvider(AUTH_TYPE, AUTH_NAME, this, { supportsMultipleAccounts: false }),
      import_vscode2.window.registerUriHandler(this._uriHandler),
      // Listen for secrets changes to sync across windows
      this.context.secrets.onDidChange((e) => {
        if (e.key === SESSIONS_SECRET_KEY) {
          this.checkForSessionChanges();
        }
      }),
      import_vscode2.window.onDidChangeWindowState((e) => {
        if (e.focused) {
          this.getSessions();
        }
      })
    );
  }
  _sessionChangeEmitter = new import_vscode2.EventEmitter();
  _disposable;
  _pendingStates = [];
  _codeExchangePromises = /* @__PURE__ */ new Map();
  _uriHandler = new UriEventHandler();
  _sessionsPromise;
  _getSessionsSingleFlight;
  _keychain;
  _isCheckingForChanges = false;
  /**
   * Check if sessions have changed and fire the appropriate events for cross-window sync
   * Similar to GitHub Authentication's approach
   */
  async checkForSessionChanges() {
    if (this._isCheckingForChanges) {
      return;
    }
    this._isCheckingForChanges = true;
    try {
      const previousSessions = await this._sessionsPromise;
      this._sessionsPromise = this.readSessions();
      const currentSessions = await this._sessionsPromise;
      const added = currentSessions.filter(
        (current) => !previousSessions.some((prev) => prev.id === current.id)
      );
      const removed = previousSessions.filter(
        (prev) => !currentSessions.some((current) => current.id === prev.id)
      );
      const changed = currentSessions.filter((current) => {
        const prev = previousSessions.find((p) => p.id === current.id);
        return prev && prev.accessToken !== current.accessToken;
      });
      if (added.length > 0 || removed.length > 0 || changed.length > 0) {
        this._sessionChangeEmitter.fire({ added, removed, changed });
      }
    } finally {
      this._isCheckingForChanges = false;
    }
  }
  get onDidChangeSessions() {
    return this._sessionChangeEmitter.event;
  }
  get redirectUri() {
    const publisher = this.context.extension.packageJSON.publisher;
    const name = this.context.extension.packageJSON.name;
    return `${import_vscode2.env.uriScheme}://${publisher}.${name}`;
  }
  /**
   * Get the existing sessions
   * @param scopes
   * @returns
   */
  async getSessions(_scopes) {
    if (this._getSessionsSingleFlight) {
      return this._getSessionsSingleFlight;
    }
    const singleFlight = this.doGetSessions();
    this._getSessionsSingleFlight = singleFlight;
    try {
      return await singleFlight;
    } finally {
      if (this._getSessionsSingleFlight === singleFlight) {
        this._getSessionsSingleFlight = void 0;
      }
    }
  }
  async doGetSessions() {
    const allSessions = await this._sessionsPromise;
    const refreshedSessions = [];
    const invalidSessions = [];
    let hasChanges = false;
    for (const session of allSessions) {
      try {
        const refreshedSession = await this.ensureTokenValid(session);
        refreshedSessions.push(refreshedSession);
        if (refreshedSession.accessToken !== session.accessToken) {
          hasChanges = true;
        }
      } catch (error) {
        console.error(`Failed to refresh token for session ${session.id}:`, error);
        let latestSessions;
        let latestSession;
        try {
          latestSessions = await this.readSessions();
          latestSession = latestSessions.find((s) => s.id === session.id);
        } catch (readError) {
          console.error(`Failed to read latest sessions after refresh failure for session ${session.id}:`, readError);
        }
        if (!latestSessions || latestSessions.length === 0) {
          for (let attempt = 0; attempt < 2; attempt++) {
            await sleep(250);
            try {
              latestSessions = await this.readSessions();
              latestSession = latestSessions.find((s) => s.id === session.id);
              if (latestSessions.length > 0) {
                break;
              }
            } catch (readError) {
              console.error(`Failed to read latest sessions after refresh failure for session ${session.id}:`, readError);
            }
          }
        }
        if (latestSessions && latestSessions.length > 0 && !latestSession) {
          latestSession = latestSessions[0];
        }
        if (latestSessions && latestSession && latestSession.id !== session.id) {
          this._sessionsPromise = Promise.resolve([...latestSessions]);
          refreshedSessions.push(latestSession);
          continue;
        }
        if (latestSessions && latestSession && (latestSession.refreshToken !== session.refreshToken || latestSession.accessToken !== session.accessToken || latestSession.expirationTimestampMs !== session.expirationTimestampMs)) {
          this._sessionsPromise = Promise.resolve([...latestSessions]);
          refreshedSessions.push(latestSession);
          continue;
        }
        invalidSessions.push(session);
        hasChanges = true;
      }
    }
    if (hasChanges) {
      if (refreshedSessions.length === 0) {
        try {
          const latestSessions = await this.readSessions();
          if (latestSessions.length > 0) {
            this._sessionsPromise = Promise.resolve([...latestSessions]);
            return latestSessions;
          }
        } catch (readError) {
          console.error("Failed to read latest sessions before storing empty sessions:", readError);
        }
      }
      await this.storeSessions(refreshedSessions);
      const changed = refreshedSessions.filter((refreshed) => {
        const original = allSessions.find((s) => s.id === refreshed.id);
        return original && original.accessToken !== refreshed.accessToken;
      });
      if (invalidSessions.length > 0 || changed.length > 0) {
        this._sessionChangeEmitter.fire({
          added: [],
          removed: invalidSessions,
          changed
        });
        if (invalidSessions.length > 0) {
          import_vscode2.window.showWarningMessage(
            "Your authentication session has expired. Please sign in again.",
            "Sign In"
          ).then((selection) => {
            if (selection === "Sign In") {
              import_vscode2.commands.executeCommand("workbench.action.accounts.signin", AUTH_TYPE);
            }
          });
        }
      }
    }
    return refreshedSessions;
  }
  /**
   * Create a new auth session
   * @param scopes
   * @returns
   */
  async createSession(_scopes) {
    try {
      const code = await this.login();
      if (!code) {
        throw new Error(`Pink login failure`);
      }
      const tokenResponse = await this.createTokenSession(code);
      const userinfo = await this.getUserInfo(tokenResponse.access_token);
      const session = {
        id: v4_default(),
        accessToken: tokenResponse.access_token,
        refreshToken: tokenResponse.refresh_token,
        expirationTimestampMs: tokenResponse.expire_at,
        account: {
          label: userinfo.name,
          // TODO: Use a unique user ID instead of name if available from userinfo
          id: userinfo.email || userinfo.name
        },
        scopes: []
      };
      const currentSessions = await this._sessionsPromise;
      const removed = [...currentSessions];
      const newSessions = [session];
      await this.storeSessions(newSessions);
      this._sessionChangeEmitter.fire({ added: [session], removed, changed: [] });
      return session;
    } catch (e) {
      console.error(`Sign in failed:`, e);
      import_vscode2.window.showErrorMessage(`Sign in failed. Please try again or check the logs for more details.`);
      throw e;
    }
  }
  /**
   * Read sessions from storage without refreshing tokens
   * Token refresh is handled lazily in getSessions() when needed
   */
  async readSessions() {
    const allSessions = await this._keychain.getToken();
    if (!allSessions) {
      return [];
    }
    return JSON.parse(allSessions);
  }
  /**
   * Store sessions to persistent storage and update cache
   * @param sessions
   */
  async storeSessions(sessions) {
    const sessionsJson = JSON.stringify(sessions);
    this._sessionsPromise = Promise.resolve([...sessions]);
    await this._keychain.setToken(sessionsJson);
  }
  /**
   * Remove an existing session
   * @param sessionId
   */
  async removeSession(sessionId) {
    const currentSessions = await this._sessionsPromise;
    const sessionIdx = currentSessions.findIndex((s) => s.id === sessionId);
    if (sessionIdx > -1) {
      const newSessions = [...currentSessions];
      const [removed] = newSessions.splice(sessionIdx, 1);
      await this.storeSessions(newSessions);
      this._sessionChangeEmitter.fire({ added: [], removed: [removed], changed: [] });
    }
  }
  /**
   * Dispose the registered services
   */
  async dispose() {
    this._disposable.dispose();
  }
  /**
   * Log in to Auth0
   */
  async login() {
    return await import_vscode2.window.withProgress(
      {
        location: import_vscode2.ProgressLocation.Notification,
        title: "login to SUD service...",
        cancellable: true
      },
      async (_, token) => {
        const stateId = v4_default();
        this._pendingStates.push(stateId);
        const searchParams = new URLSearchParams([
          ["channel", "pink_ide"],
          ["redirect_uri", this.redirectUri],
          ["state", stateId]
        ]);
        const { auth0Domain } = await getAPIUrl();
        const uri = import_vscode2.Uri.parse(`${auth0Domain}/?${searchParams.toString()}`);
        await import_vscode2.env.openExternal(uri);
        const cacheKey = stateId;
        let codeExchangePromise = this._codeExchangePromises.get(cacheKey);
        if (!codeExchangePromise) {
          codeExchangePromise = promiseFromEvent(this._uriHandler.event, this.handleUri());
          this._codeExchangePromises.set(cacheKey, codeExchangePromise);
        }
        try {
          return await Promise.race([
            codeExchangePromise.promise,
            new Promise((_2, reject) => setTimeout(() => reject("Cancelled"), LOGIN_TIMEOUT_MS)),
            promiseFromEvent(token.onCancellationRequested, (_2, __, reject) => {
              reject("User Cancelled");
            }).promise
          ]);
        } finally {
          this._pendingStates = this._pendingStates.filter((n) => n !== stateId);
          codeExchangePromise?.cancel.fire();
          this._codeExchangePromises.delete(cacheKey);
        }
      }
    );
  }
  /**
   * Handle the redirect to VS Code (after sign in from Auth0)
   * @returns
   */
  handleUri = () => async (uri, resolve, reject) => {
    const query = new URLSearchParams(uri.query);
    const code = query.get("sud_auth_code");
    const state = query.get("state");
    if (!code) {
      reject(new Error("No code"));
      return;
    }
    if (!state) {
      reject(new Error("No state"));
      return;
    }
    if (!this._pendingStates.some((n) => n === state)) {
      reject(new Error("State not found"));
      return;
    }
    resolve(code);
  };
  async _fetchApi(path, options) {
    const { apiUrl } = await getAPIUrl();
    const response = await fetch(`${apiUrl}${path}`, {
      method: options.method ?? "GET",
      headers: {
        "Content-Type": "application/json",
        ...options.headers
      },
      body: options.body ? JSON.stringify(options.body) : void 0
    });
    if (!response.ok) {
      throw new Error(`Request to ${path} failed: ${response.statusText}`);
    }
    try {
      const result = await response.json();
      if (result.ret_code !== 0) {
        throw new Error(`API Error for ${path}: ${result.ret_msg} (code: ${result.ret_code})`);
      }
      return result.data;
    } catch (error) {
      if (error instanceof Error) {
        throw error;
      }
      throw new Error(`Failed to parse response from ${path}: ${error}`);
    }
  }
  /**
   * Get the user info from Auth0
   * @param token
   * @returns
   */
  async getUserInfo(access_token) {
    return this._fetchApi("/api/user/info", {
      headers: { "x-sud-at": access_token }
    });
  }
  async createTokenSession(code) {
    let license;
    try {
      license = await import_vscode2.commands.executeCommand("cocos.license.getLicense");
    } catch (error) {
      console.error("Failed to get license:", error);
      throw new Error("License command is not available. Please ensure the Cocos extension is installed and active.");
    }
    return this._fetchApi("/api/token/create", {
      method: "POST",
      body: { code },
      headers: {
        "Auth-Token": license
      }
    });
  }
  async refreshTokenSession(refresh_token) {
    return this._fetchApi("/api/token/refresh", {
      method: "POST",
      headers: { "x-sud-rt": refresh_token },
      body: {}
    });
  }
  async ensureTokenValid(session) {
    if (Date.now() >= session.expirationTimestampMs - REFRESH_TOKEN_BUFFER_MS) {
      const tokenResponse = await this.refreshTokenSession(session.refreshToken);
      return {
        ...session,
        accessToken: tokenResponse.access_token,
        refreshToken: tokenResponse.refresh_token,
        expirationTimestampMs: tokenResponse.expire_at
      };
    }
    return session;
  }
};

// extensions/sud-authentication/src/extension.ts
var vscode = __toESM(require("vscode"));
async function activate(context) {
  const subscriptions = context.subscriptions;
  const provider = new pinkAuthenticationProvider(context);
  subscriptions.push(provider);
  subscriptions.push(
    vscode.commands.registerCommand("sud-authentication.signIn", async () => {
      await provider.createSession([]);
    })
  );
  const updateSignedInContext = async () => {
    const session = await provider.getSessions();
    await vscode.commands.executeCommand("setContext", "pink.signedIn", session.length > 0);
  };
  updateSignedInContext();
  subscriptions.push(
    vscode.authentication.onDidChangeSessions(async (e) => {
      if (e.provider.id === AUTH_TYPE) {
        await updateSignedInContext();
      }
    })
  );
}
function deactivate() {
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  activate,
  deactivate
});
//# sourceMappingURL=extension.js.map
