# Cocos CLI MCP Extension

A VS Code extension that helps you configure and manage HTTP MCP (Model Context Protocol) servers for enhanced AI-powered development workflows.

## Features

- **Easy MCP Server Configuration**: Simple commands to add HTTP MCP servers to your workspace <mcreference link="https://code.visualstudio.com/docs/copilot/chat/mcp-servers" index="1">1</mcreference>
- **Workspace Integration**: Creates `.vscode/mcp.json` configuration files for team sharing <mcreference link="https://code.visualstudio.com/docs/copilot/chat/mcp-servers" index="1">1</mcreference>
- **User-Friendly Interface**: Guided setup with input validation and help documentation
- **Standard Compliance**: Follows VS Code's official MCP configuration format <mcreference link="https://code.visualstudio.com/api/extension-guides/ai/mcp" index="2">2</mcreference>

## Installation

1. Install dependencies:
   ```bash
   npm install
   ```

2. Compile the extension:
   ```bash
   npm run compile
   ```

3. Install in VS Code:
   - Press `F5` to run the extension in a new Extension Development Host window
   - Or package and install: `vsce package && code --install-extension cocos-cli-*.vsix`

## Usage

### Adding an MCP Server

1. Open the Command Palette (`Cmd+Shift+P` / `Ctrl+Shift+P`)
2. Run the command: **"Cocos CLI: Add MCP Server"**
3. Enter the HTTP URL of your MCP server (e.g., `https://api.example.com/mcp`)
4. Provide a name for the server (e.g., "My Custom MCP Server")
5. The extension will create/update `.vscode/mcp.json` in your workspace

### Getting Help

Run the command **"Cocos CLI: Show MCP Help"** to view detailed documentation about MCP configuration and usage.

## Configuration Format

The extension creates configuration files in the standard VS Code MCP format: <mcreference link="https://code.visualstudio.com/docs/copilot/chat/mcp-servers" index="1">1</mcreference>

```json
{
  "servers": {
    "My MCP Server": {
      "type": "http",
      "url": "https://api.example.com/mcp"
    }
  }
}
```

## Supported MCP Server Types

- **HTTP**: Remote servers accessible via HTTP/HTTPS <mcreference link="https://code.visualstudio.com/api/extension-guides/ai/mcp" index="2">2</mcreference>
- **Server-Sent Events (SSE)**: For real-time communication <mcreference link="https://code.visualstudio.com/api/extension-guides/ai/mcp" index="2">2</mcreference>

## Examples of MCP Servers

- **GitHub MCP Server**: `https://api.githubcopilot.com/mcp` <mcreference link="https://medium.com/towards-agi/how-to-set-up-and-use-vscode-mcp-server-352c1e6f42e9" index="5">5</mcreference>
- **Custom API Servers**: Your own HTTP MCP implementations
- **Third-party Services**: Various MCP-compatible services from the ecosystem

## How It Works

1. **Configuration**: The extension helps you create `.vscode/mcp.json` files with proper MCP server definitions <mcreference link="https://code.visualstudio.com/docs/copilot/chat/mcp-servers" index="1">1</mcreference>
2. **Integration**: VS Code automatically reads these configurations and connects to the specified MCP servers <mcreference link="https://code.visualstudio.com/api/extension-guides/ai/mcp" index="2">2</mcreference>
3. **AI Enhancement**: The MCP servers provide tools and capabilities that enhance GitHub Copilot's agent mode <mcreference link="https://medium.com/towards-agi/how-to-set-up-and-use-vscode-mcp-server-352c1e6f42e9" index="5">5</mcreference>

## Development

### Build Commands
- `npm run compile` - Compile TypeScript to JavaScript
- `npm run watch` - Watch for changes and recompile
- `npm test` - Run extension tests

### Testing
Test the extension by:
1. Running it in the Extension Development Host
2. Using the "Add MCP Server" command with a test URL
3. Verifying the `.vscode/mcp.json` file is created correctly

## Requirements

- VS Code 1.102 or later (for MCP support) <mcreference link="https://code.visualstudio.com/docs/copilot/chat/mcp-servers" index="1">1</mcreference>
- GitHub Copilot extension (for AI agent mode)
- Access to HTTP MCP servers you want to configure

## Version History

### 0.0.1
- Initial release with MCP server configuration commands
- Support for HTTP MCP server setup
- Integrated help documentation and user guidance
- Standard VS Code MCP configuration format compliance
