"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.McpServerManager = void 0;
const vscode = __importStar(require("vscode"));
const path = __importStar(require("path"));
const child_process_1 = require("child_process");
/**
 * 获取 MCP 启动脚本的绝对路径
 * @param enginePath Cocos 引擎根目录
 * @returns `dist/mcp/start-server.js` 的绝对路径
 */
function getMcpStartPath(enginePath) {
    return path.join(enginePath, 'dist/mcp/start-server.js');
}
/**
 * 管理 Cocos CLI MCP 服务器子进程的启动与停止
 */
class McpServerManager {
    _process;
    _url;
    _onDidStop = new vscode.EventEmitter();
    /**
     * MCP 服务器停止事件
     */
    onDidStop = this._onDidStop.event;
    /**
     * 启动 MCP 服务器
     * @param projectPath 项目根目录
     * @param enginePath 引擎根目录（作为 cwd）
     * @returns 服务器 URL (例如 http://localhost:3000)
     */
    async start(projectPath, enginePath) {
        // 如果已经启动且 URL 已知，直接返回（避免重复启动）
        // 注意：外部逻辑可能已经通过 hasStartedMcpServer 控制了，但这里做个双重检查也好
        // 不过为了支持重启（如果进程意外退出），我们主要看 _process 是否存在
        if (this._process && this._url) {
            return this._url;
        }
        this.stop(); // 确保之前的进程已清理
        // 构造 start-server.js 路径
        const startServerJsPath = getMcpStartPath(enginePath);
        // 构造启动脚本内容，直接 require 模块并调用 startServer
        // 1. 注入 process.addGlobalOpenUrl 代理，通过 IPC 通讯请求父进程打开 URL
        // 2. 直接调用 startServer
        const scriptContent = `
			process.addGlobalOpenUrl = function(url) {
				if (process.send) {
					process.send({ command: 'open_url', url: url });
				}
			};
			const { startServer } = require(${JSON.stringify(startServerJsPath)});
			startServer(${JSON.stringify(projectPath)}).catch(console.error);
		`;
        return new Promise((resolve, reject) => {
            console.log(`Starting MCP server via wrapper: ${process.execPath} -e ...`);
            this._process = (0, child_process_1.spawn)(process.execPath, ['-e', scriptContent], {
                cwd: enginePath,
                env: { ...process.env, ELECTRON_RUN_AS_NODE: '1' },
                stdio: ['pipe', 'pipe', 'pipe', 'ipc']
            });
            // 监听子进程的 IPC 消息，处理 open_url 请求
            this._process.on('message', (msg) => {
                if (msg && msg.command === 'open_url' && msg.url) {
                    vscode.commands.executeCommand('simpleBrowser.show', msg.url);
                }
            });
            this._process.stdout?.on('data', (data) => {
                const output = data.toString();
                console.log(`[MCP] ${output}`);
                // 匹配输出中的 URL
                const match = output.match(/Server is running on:\s*(http:\/\/[^\s]+)/);
                if (match) {
                    this._url = match[1];
                    resolve(this._url);
                }
            });
            this._process.stderr?.on('data', (data) => {
                console.error(`[MCP] ${data}`);
            });
            this._process.on('error', (err) => {
                console.error(`[MCP Launch Error]`, err);
                reject(err);
            });
            this._process.on('exit', (code) => {
                console.log(`MCP server exited with code ${code}`);
                // 如果在获取到 URL 之前退出，则是启动失败
                if (!this._url) {
                    reject(new Error(`MCP server exited with code ${code}`));
                }
                // 进程退出后清理状态
                this._process = undefined;
                this._url = undefined;
                // 触发停止事件
                this._onDidStop.fire();
            });
        });
    }
    /**
     * 停止 MCP 服务器
     */
    stop() {
        if (this._process) {
            this._process.kill();
            // 状态清理和事件触发由 exit 事件统一处理
        }
    }
    /**
     * 销毁资源（停止服务器）
     */
    dispose() {
        this.stop();
    }
}
exports.McpServerManager = McpServerManager;
//# sourceMappingURL=mcpServer.js.map